// Photoshop: Convert Images to sRGB IEC61966-2.1
// Processes all images in a selected folder and saves them as JPEGs in an output folder

// ------------------------------------------------------
// MAIN FUNCTION
// ------------------------------------------------------
function main() {

    // --- Step 1: Ask user to select source folder ---
    alert("Please select the folder containing the images you want to convert to sRGB.");
    var sourceFolder = Folder.selectDialog("Select the folder containing your images:");
    if (!sourceFolder) return;

    // --- Step 2: Ask user to select or create output folder ---
    alert("Now, please select (or create) the folder where the converted images will be saved.");
    var outputFolder = Folder.selectDialog("Select the folder to save converted images:");
    if (!outputFolder) return;

    // Get list of supported images
    var files = sourceFolder.getFiles(/\.(jpg|jpeg|tif|tiff|png|psd)$/i);

    if (files.length === 0) {
        alert("No supported image files found in the selected folder.");
        return;
    }

    // Process each image
    for (var i = 0; i < files.length; i++) {
        try {
            var file = files[i];
            var doc = app.open(file);

            // Convert to sRGB IEC61966-2.1
            convertToSRGB(doc);

            // Save as JPEG
            saveAsJPG(doc, outputFolder);

            doc.close(SaveOptions.DONOTSAVECHANGES);

        } catch (e) {
            alert("Error processing file: " + file.name + "\n" + e.message);
        }
    }

    alert("All images have been converted to sRGB and saved in:\n" + outputFolder.fsName);
}

// ------------------------------------------------------
// CONVERT TO SRGB FUNCTION
// ------------------------------------------------------
function convertToSRGB(doc) {
    doc.convertProfile("sRGB IEC61966-2.1", Intent.RELATIVECOLORIMETRIC, true, false);
}

// ------------------------------------------------------
// SAVE AS JPEG FUNCTION
// ------------------------------------------------------
function saveAsJPG(doc, outputFolder) {
    var baseName = doc.name.replace(/\.[^\.]+$/, "");
    var outFile = new File(outputFolder + "/" + baseName + "_sRGB.jpg");

    var opts = new JPEGSaveOptions();
    opts.quality = 12;
    opts.embedColorProfile = true;

    doc.saveAs(outFile, opts, true, Extension.LOWERCASE);
}

// ------------------------------------------------------
// RUN THE SCRIPT
// ------------------------------------------------------
main();
